#pragma semicolon 1

#include <sourcemod>
#include <sdktools>

#define L4D_TEAM_UNASSIGNED 0
#define L4D_TEAM_SPECTATOR 1
#define L4D_TEAM_SURVIVOR 2
#define L4D_TEAM_INFECTED 3

new Handle:hTimer = INVALID_HANDLE;
new Handle:hGameMode = INVALID_HANDLE;
new Handle:hTakeOverBot = INVALID_HANDLE;
new Handle:hRoundRespawn = INVALID_HANDLE;
new Handle:hSetHumanSpectator = INVALID_HANDLE;
new Handle:hAfkRespawn = INVALID_HANDLE;
new Handle:hConfigAFK = INVALID_HANDLE;
new Handle:hConfigKillme = INVALID_HANDLE;
new Handle:hConfigRejoin = INVALID_HANDLE;
new Handle:hConfigChance = INVALID_HANDLE;

new offsetHumanSpectatorUserID = -1;
new maxPlayers = 0;
new bool:isFinale = false;
new bool:ChanceSpawn[MAXPLAYERS+1] = {false,};

// command name
new String:sAFK[][] = { "afk", "\x03!afk\x04" };
new String:sKILLME[][] = { "killme", "\x03!killme\x04" };
new String:sCHANCE[][] = { "chance", "\x03!chance\x04" };
new String:sREJOIN[][] = { "rejoin", "\x03!rejoin\x04" };

public Plugin:myinfo = {
	name = "L4D Player Command",
	author = "NiCo-op",
	description = "",
	version = "0.0.7",
	url = "http://nico-op.forjp.net/"
};

public GetActivePlayer(const team)
{
	for(new i=1; i <= maxPlayers; i++){
		if(IsClientConnected(i) && IsClientInGame(i) && IsPlayerAlive(i) && GetClientTeam(i) == team){
			return i;
		}
	}
	return 0;
}

public GetSurvivorBot(const client, const bool:bAlive)
{
	for(new i=1; i <= maxPlayers; i++){
		if(IsClientConnected(i) && IsFakeClient(i) && GetClientTeam(i) == L4D_TEAM_SURVIVOR){
			new owner = GetClientOfUserId(GetEntData(i, offsetHumanSpectatorUserID));
			if(owner != 0 && owner != client && IsClientConnected(owner)){
				continue;
			}
			if(bAlive){
				if(IsPlayerAlive(i)){
					return i;
				}
			} else {
				if(!IsPlayerAlive(i)){
					return i;
				}
			}
		}
	}
	return 0;
}

public GetTeamClientCount2(const team){
	new result = 0;
	for(new i=1; i <= maxPlayers; i++){
		if(IsClientConnected(i) && !IsFakeClient(i) && IsClientInGame(i) && GetClientTeam(i) == team){
			result++;
		}
	}
	return result;
}

public OnPluginStart()
{
	LoadTranslations("plugin.l4d_player");
	hGameMode = FindConVar("mp_gamemode");

	new Handle:hConfig = LoadGameConfigFile("l4d_player");
	if(hConfig == INVALID_HANDLE){
		SetFailState("Could not load gamedata/l4d_player.");
	}
	else{
		StartPrepSDKCall(SDKCall_Player);
		if(PrepSDKCall_SetFromConf(hConfig, SDKConf_Signature, "RoundRespawn")){
			hRoundRespawn = EndPrepSDKCall();
		}
		if(hRoundRespawn == INVALID_HANDLE){
			SetFailState("Could not find the correct offsets@l4drespawn.");
		}

		StartPrepSDKCall(SDKCall_Player);
		if(PrepSDKCall_SetFromConf(hConfig, SDKConf_Signature, "SetHumanSpec")){
			PrepSDKCall_AddParameter(SDKType_CBasePlayer, SDKPass_Pointer);
			hSetHumanSpectator = EndPrepSDKCall();
		}
	
		StartPrepSDKCall(SDKCall_Player);
		if(PrepSDKCall_SetFromConf(hConfig, SDKConf_Signature, "TakeOverBot")){
			PrepSDKCall_AddParameter(SDKType_Bool, SDKPass_Plain);
			hTakeOverBot = EndPrepSDKCall();
		}
		
		if(hSetHumanSpectator == INVALID_HANDLE || hTakeOverBot == INVALID_HANDLE){
			SetFailState("Could not find the correct signatures@l4d_takeoverbot.");
		}
	}
	offsetHumanSpectatorUserID = FindSendPropOffs("SurvivorBot", "m_humanSpectatorUserID");

	hAfkRespawn = CreateConVar("l4d_afkrespawn", "0", " none ", FCVAR_NOTIFY, true, 0.0, true, 1.0);
	hConfigAFK = CreateConVar("l4d_player_afk", "1", " none ", FCVAR_NOTIFY, true, 0.0, true, 1.0);
	hConfigKillme = CreateConVar("l4d_player_killme", "0", " none ", FCVAR_NOTIFY, true, 0.0, true, 1.0);
	hConfigChance = CreateConVar("l4d_player_chance", "1", " none ", FCVAR_NOTIFY, true, 0.0, true, 1.0);
	hConfigRejoin = CreateConVar("l4d_player_rejoin", "1", " none ", FCVAR_NOTIFY, true, 0.0, true, 1.0);

	HookEvent("finale_start", OnFinaleStart);
	HookEvent("finale_radio_start", OnFinaleStart);
	HookEvent("player_death", OnPlayerDeath);
	HookEvent("round_start", OnRoundStart);

	RegConsoleCmd(sAFK[0], CommandAFK);
	RegConsoleCmd(sKILLME[0], CommandKILL);
	RegConsoleCmd(sCHANCE[0], CommandChance);
	RegConsoleCmd(sREJOIN[0], CommandRejoin);
}

public OnClientPutInServer(client){
	if(isFinale){
		ChanceSpawn[client] = true;
		PrintToChat(client, "\x04[INFO] %t", "unlock chance", sCHANCE[1]);
		PrintToChat(client, "\x04[INFO] %t", "info chance", sCHANCE[1]);
	}
}

public Action:OnFinaleStart(Handle:hEvent, const String:sName[], bool:bDontBroadcast)
{
	if(hTimer == INVALID_HANDLE && GetConVarBool(hConfigChance)){
		decl String:sGameMode[16];
		GetConVarString(hGameMode, sGameMode, sizeof(sGameMode));

		if(StrEqual(sGameMode, "coop") || StrEqual(sGameMode, "realism")){
			hTimer = CreateTimer(3.0, TimerFinaleEvent, _, TIMER_FLAG_NO_MAPCHANGE);
		}
	}
	return Plugin_Continue;
}

public Action:OnPlayerDeath(Handle:hEvent, const String:sName[], bool:bDontBroadcast)
{
	new client = GetClientOfUserId(GetEventInt(hEvent, "userid"));
	if(client && IsClientConnected(client) && !IsFakeClient(client)){
		if(GetClientTeam(client) == L4D_TEAM_SURVIVOR){
			if(isFinale && ChanceSpawn[client]){
				PrintToChat(client, "\x04[INFO] %t", "unlock chance", sCHANCE[1]);
				PrintToChat(client, "\x04[INFO] %t", "info chance", sCHANCE[1]);
				PrintHintText(client, "%t", "hint chance");
			}
			else if(GetConVarBool(hConfigRejoin)){
				PrintToChat(client, "\x04[INFO] %t", "unlock rejoin", sREJOIN[1]);
				PrintToChat(client, "\x04[INFO] %t", "info rejoin", sREJOIN[1]);
				PrintHintText(client, "%t", "hint rejoin");
			}
		}
	}
	return Plugin_Continue;
}

public Action:OnRoundStart(Handle:hEvent, const String:sName[], bool:bDontBroadcast)
{
	maxPlayers = GetMaxClients();
	isFinale = false;
	hTimer = INVALID_HANDLE;
	for(new i=0; i <= maxPlayers; i++){
		ChanceSpawn[i] = false;
	}
	return Plugin_Continue;
}

public Action:TimerFinaleEvent(Handle:timer, any:value)
{
	if(!isFinale && hTimer == timer){
		isFinale = true;
		for(new i=0; i <= maxPlayers; i++)	{
			ChanceSpawn[i] = true;
		}
		PrintToChatAll("\x04[INFO] %t", "unlock chance", sCHANCE[1]);
		PrintToChatAll("\x04[INFO] %t", "info chance", sCHANCE[1]);
	}
	return Plugin_Stop;
}

public Action:CommandAFK(client, args){
	if(!GetConVarBool(hConfigAFK)){
		return Plugin_Continue;
	}
	ChangeClientTeam(client, L4D_TEAM_SPECTATOR);
	return Plugin_Handled;
}

public Action:CommandKILL(client, args)
{
	if(!GetConVarBool(hConfigKillme)){
		return Plugin_Continue;
	}

	if(client
		&& IsClientConnected(client)
		&& !IsFakeClient(client)
		&& IsClientInGame(client)
		&& IsPlayerAlive(client)
		&& GetClientTeam(client) == L4D_TEAM_SURVIVOR
	){
		ForcePlayerSuicide(client);
	}
	return Plugin_Handled;
}

public Action:CommandChance(client, args)
{
	if(!GetConVarBool(hConfigChance)){
		return Plugin_Continue;
	}

	decl String:sGameMode[16];
	GetConVarString(hGameMode, sGameMode, sizeof(sGameMode));

	if((!StrEqual(sGameMode, "coop") && !StrEqual(sGameMode, "realism"))
		|| !ChanceSpawn[client]
		|| !IsClientConnected(client)
		|| !IsClientInGame(client)
		|| IsPlayerAlive(client)
		|| GetClientTeam(client) != L4D_TEAM_SURVIVOR
	){
		PrintToChat(client, "\x04[INFO] %t", "block chance", sCHANCE[1]);
	}
	else if(hRoundRespawn != INVALID_HANDLE){
		ChanceSpawn[client] = false;
		new player = GetActivePlayer(L4D_TEAM_SURVIVOR);
		if(player){
			SDKCall(hRoundRespawn, client);
			if(IsValidEntity(client)){
				decl Float:fOrigin[3];
				GetClientAbsOrigin(player, fOrigin);
				TeleportEntity(client, fOrigin, NULL_VECTOR, NULL_VECTOR);
			}
		}
	}
	return Plugin_Handled;
}

public Action:CommandRejoin(client, args)
{
	if(!GetConVarBool(hConfigRejoin)){
		return Plugin_Continue;
	}

	decl String:sGameMode[16];
	GetConVarString(hGameMode, sGameMode, sizeof(sGameMode));

	if (IsClientConnected(client)
	  && !IsFakeClient(client)
	  && IsClientInGame(client)
	  && !IsPlayerAlive(client)
	  && GetClientTeam(client) == L4D_TEAM_SURVIVOR
	){
		new bot = GetSurvivorBot(client, true);
		if(bot){
			ChangeClientTeam(client, L4D_TEAM_SPECTATOR);
			SDKCall(hSetHumanSpectator, bot, client);
			SDKCall(hTakeOverBot, client, true);
			ChangeClientTeam(client, L4D_TEAM_SURVIVOR);
		}
		else{
			PrintToChat(client, "\x04[INFO] %t", "block rejoin", sREJOIN[1]);
		}
	}
	else if(StrEqual(sGameMode, "versus")){
		FakeClientCommand(client,"jointeam 3");
		// ChangeClientTeam(client, L4D_TEAM_INFECTED);
	}
	else if(GetClientTeam(client) == L4D_TEAM_SPECTATOR){
		new bot = GetSurvivorBot(0, true);
		if(!GetConVarBool(hAfkRespawn)){
			if(bot){
				SDKCall(hSetHumanSpectator, bot, client);
				SDKCall(hTakeOverBot, client, true);
				ChangeClientTeam(client, L4D_TEAM_SURVIVOR);
			}
			else{
				PrintToChat(client, "\x04[INFO] %t", "block rejoin", sREJOIN[1]);
			}
		}
		else{
			if(!bot && (StrEqual(sGameMode, "coop") || StrEqual(sGameMode, "realism"))
			  && hRoundRespawn != INVALID_HANDLE){
				bot = GetSurvivorBot(0, false);
				new player = GetActivePlayer(L4D_TEAM_SURVIVOR);
				if(bot && player){
					SDKCall(hRoundRespawn, bot);
					if(IsValidEntity(bot)){
						decl Float:fOrigin[3];
						SetEntityHealth(bot, 50);
						GetClientAbsOrigin(player, fOrigin);
						TeleportEntity(bot, fOrigin, NULL_VECTOR, NULL_VECTOR);
					}
				}
			}
			SDKCall(hSetHumanSpectator, bot, client);
			SDKCall(hTakeOverBot, client, true);
			ChangeClientTeam(client, L4D_TEAM_SURVIVOR);
		}
	}
	return Plugin_Handled;
}
