#pragma semicolon 1

#include <sourcemod>
#include <geoip>

#define PLUGIN_VERSION "0.0.2"

new Handle:hMode;
new Handle:hNames;
new Handle:hCode2;
new Handle:hCountry;
new Handle:hCountries;
new Handle:hConnectMessage;
// new Handle:hRejectMessage;

public Plugin:myinfo =
{
	name = "Country Filter Plus",
	author = "Nico-op",
	description = "Country Filter Plus",
	version = PLUGIN_VERSION,
	url = "http://nico-op.forjp.net/"
};

public OnPluginStart()
{
	CreateConVar("cf_plus_version",
		PLUGIN_VERSION,
		"Country Filter Plus version",
		FCVAR_PLUGIN|FCVAR_SPONLY|FCVAR_NOTIFY|FCVAR_REPLICATED|FCVAR_DONTRECORD
	);

	hMode = CreateConVar("cf_mode", "1", "", FCVAR_PLUGIN);
	hNames = CreateConVar("cf_names", "", "", FCVAR_PLUGIN);
	hCountries = CreateConVar("cf_countries", "", "", FCVAR_PLUGIN);
	hCode2 = CreateConVar("cf_private_code2", "--", "", FCVAR_PLUGIN);
	hCountry = CreateConVar("cf_private_country", "ADMIN", "", FCVAR_PLUGIN);

	hConnectMessage = CreateConVar("cf_connect_msg", "< %s > has joined (Country: %s)", "", FCVAR_PLUGIN);
	// hRejectMessage = CreateConVar("cf_reject_msg", "Your country (%s) isn't allowed on this server", "", FCVAR_PLUGIN);
}

public bool:OnClientConnect(client, String:rejectmsg[], maxlen)
{
	if( !client || IsFakeClient(client) ){
		return true;
	}

	new String:output[512];
	new String:msg[512];
	new String:ip[16];
	new String:code2[3];
	new String:country[64];
	new String:name[MAX_NAME_LENGTH];

	if(GetClientIP(client, ip, sizeof(ip))){
		GeoipCode2(ip, code2);
		GeoipCountry(ip, country, sizeof(country));
		if(Reject(code2)){
			return false;
		}
	}

	// Private IP (Admin)
	if(!StrContains(ip, "10.")
	  || !StrContains(ip, "172.")
	  || !StrContains(ip, "192.168.")){
		GetConVarString(hCode2, code2, sizeof(code2));
		GetConVarString(hCountry, country, sizeof(country));
	}

	if(GetClientName(client, name, sizeof(name))){
		if(RejectName(name)){
			return false;
		}
		GetConVarString(hConnectMessage, msg, sizeof(msg));
		if(strlen(msg) > 0){
			Format(output, sizeof(output), msg, name, country);
			PrintToChatAll("\x04%s", output);
		}
	}

	return true;
}

public bool:Reject(const String:code2[])
{
	if(strlen(code2) < 2){
		return false;
	}

	new String:str[512];
	new String:arr[100][3];
	GetConVarString(hCountries, str, sizeof(str));

	new total = ExplodeString(str, " ", arr, 100, 3);
	if(total == 0) strcopy(arr[total++], 3, str);

	if(GetConVarInt(hMode) == 2){
		for(new i=0; i<total; i++){
			if(StrEqual(arr[i], code2)){
				return true;
			}
		}
		return false;
	}

	for(new i=0; i<total; i++){
		if(StrEqual(arr[i], code2)){
			return false;
		}
	}

	return true;
}

public bool:RejectName(const String:name[])
{
	if(strlen(name) < 1){
		return false;
	}

	new String:str[512];
	new String:arr[50][10];

	GetConVarString(hNames, str, sizeof(str));
	if(strlen(str) < 1) return false;

	new total = ExplodeString(str, " ", arr, 50, 10);
	if(total == 0) strcopy(arr[total++], 10, str);

	for(new i=0; i<total; i++){
		if(StrContains(name, arr[i], false) != -1){
			return true;
		}
	}

	return false;
}
