#pragma semicolon 1

#include <sourcemod>
#include <sdktools>
#define PLUGIN_NAME "L4D Come Command"
#define PLUGIN_VERSION "0.0.2"

#define L4D_TEAM_UNASSIGNED 0
#define L4D_TEAM_SPECTATOR 1
#define L4D_TEAM_SURVIVOR 2
#define L4D_TEAM_INFECTED 3


new bool:bCALL[MAXPLAYERS+1];
new cntBOT[MAXPLAYERS+1];
new regCMD = 0;
new Handle:hCOME = INVALID_HANDLE;
new Handle:hCOUNT = INVALID_HANDLE;
new Handle:hCmdBOT = INVALID_HANDLE;
new Handle:hCmdCOME = INVALID_HANDLE;
new Handle:hCmdHELP = INVALID_HANDLE;
new Handle:hSubCOME = INVALID_HANDLE;
new Handle:hSubHELP = INVALID_HANDLE;

public Plugin:myinfo = {
	name = PLUGIN_NAME,
	author = "NiCo-op",
	description = "",
	version = PLUGIN_VERSION,
	url = "http://nico-op.forjp.net/"
};

public OnPluginStart()
{
	CreateConVar("l4d_come_version", PLUGIN_VERSION, PLUGIN_NAME, FCVAR_PLUGIN|FCVAR_SPONLY|FCVAR_REPLICATED|FCVAR_NOTIFY|FCVAR_DONTRECORD);
	hCOME = CreateConVar("l4d_come", "0", "come: enable(1)/disable(0)", FCVAR_PLUGIN|FCVAR_NOTIFY, true, 0.0, true, 1.0);
	hCOUNT = CreateConVar("l4d_comebot", "99", "come limit: 0-999", FCVAR_PLUGIN|FCVAR_NOTIFY, true, 0.0, true, 999.0);
	hCmdBOT = CreateConVar("l4d_comecmd_bot", "sm_bot", "chat command:bot");
	hCmdCOME = CreateConVar("l4d_comecmd_come", "sm_come", "chat command:come");
	hCmdHELP = CreateConVar("l4d_comecmd_help", "sm_help", "chat command:help");
	hSubCOME = CreateConVar("l4d_comecmd_come_sub", "sm_c", "chat short command:come");
	hSubHELP = CreateConVar("l4d_comecmd_help_sub", "sm_h", "chat short command:help");
	HookEvent("round_start_post_nav", OnRoundStart);
	HookEvent("player_incapacitated", OnPlayerIncapacitated);

	AutoExecConfig(true, "l4d_come");
}

public OnConfigsExecuted()
{
	if(!regCMD){
		regCMD = 1;
		decl String:cmd[64];
		if(GetConVarString(hCmdHELP, cmd, sizeof(cmd))){
			RegConsoleCmd(cmd, CommandHELP);
		}
		if(GetConVarString(hCmdCOME, cmd, sizeof(cmd))){
			RegConsoleCmd(cmd, CommandCOME);
		}
		if(GetConVarString(hSubHELP, cmd, sizeof(cmd))){
			RegConsoleCmd(cmd, CommandHELP);
		}
		if(GetConVarString(hSubCOME, cmd, sizeof(cmd))){
			RegConsoleCmd(cmd, CommandCOME);
		}
		if(GetConVarString(hCmdBOT, cmd, sizeof(cmd))){
			RegConsoleCmd(cmd, CommandBOT);
		}
	}
}

public OnClientPutInServer(client)
{
	if(0 <= client && client < MAXPLAYERS+1){
		bCALL[client] = false;
		cntBOT[client] = 0;
	}
}

public Action:OnRoundStart(Handle:event, const String:name[], bool:dontBroadcast)
{
	for(new i=0; i<MAXPLAYERS+1; i++){
		bCALL[i] = false;
		cntBOT[i] = 0;
	}
	return Plugin_Continue;
}

public Action:OnPlayerIncapacitated(Handle:event, const String:name[], bool:dontBroadcast)
{
	new client = GetClientOfUserId(GetEventInt(event, "userid"));
	if(0 <= client && client < MAXPLAYERS+1){
		bCALL[client] = false;
	}

	return Plugin_Continue;
}

public Action:CommandCOME(client, args)
{
	if((args == -1 || (GetConVarBool(hCOME) && !GetEntProp(client, Prop_Send, "m_isIncapacitated")))
		&& client
		&& IsClientConnected(client)
		&& !IsFakeClient(client)
		&& IsClientInGame(client)
		&& IsPlayerAlive(client)
		&& GetClientTeam(client) == L4D_TEAM_SURVIVOR
	){
		new nPlayer;
		new nClients[32];
		new length = 0;
		decl Float:fPos[32];
		decl Float:fWork;
		decl Float:fOrigin[3];
		decl Float:fOwnerOrigin[3];

		GetEntPropVector(client, Prop_Send, "m_vecOrigin", fOwnerOrigin);
		for(nPlayer=1; nPlayer <= GetMaxClients(); nPlayer++){
			if(nPlayer != client
			  && IsClientConnected(nPlayer)
			  && IsClientInGame(nPlayer)
			  && IsPlayerAlive(nPlayer)
			  && GetClientTeam(nPlayer) == L4D_TEAM_SURVIVOR
			  && (   (args == -1 && IsFakeClient(nPlayer))
			      || (args != -1 && !IsFakeClient(nPlayer) && bCALL[nPlayer]
			           && GetEntProp(nPlayer, Prop_Send, "m_isIncapacitated")
			         )
			     )
			){
				nClients[length] = nPlayer;
				fPos[length] = 0.0;
				GetEntPropVector(nPlayer, Prop_Send, "m_vecOrigin", fOrigin);
				for(new i=0; i<3; i++){
					fWork = fOwnerOrigin[i] - fOrigin[i];
					if(fWork < 0.0) fWork *= -1;
					fPos[length] += fWork;
				}
				length++;
			}
		}

		// sort
		for(new i=0; i<length-1; i++){
			for(new j=i+1; j<length; j++){
				if(fPos[i] < fPos[j]){
					fWork = fPos[i];
					fPos[i] = fPos[j];
					fPos[j] = fWork;

					nPlayer = nClients[i];
					nClients[i] = nClients[j];
					nClients[j] = nPlayer;
				}
			}
		}

		if(length){
			bCALL[nClients[0]] = false;
			TeleportEntity(nClients[0], fOwnerOrigin, NULL_VECTOR, NULL_VECTOR);
		}
	}
	return Plugin_Handled;
}

public Action:CommandHELP(client, args)
{
	if(0 <= client && client < MAXPLAYERS+1){
		bCALL[client] = true;
	}
	return Plugin_Handled;
}

public Action:CommandBOT(client, args)
{
	new count = GetConVarInt(hCOUNT);
	if(count && 0 <= client && client < MAXPLAYERS+1){
		if(cntBOT[client] < count){
			cntBOT[client]++;
			CommandCOME(client, -1);
		}
		PrintToChat(client, "\x04[BOT] \x01command limit: %d/%d", cntBOT[client], count);
	}

	return Plugin_Handled;
}
